//
//  MCAlertAbstractActionView.h
//  MCApplication
//
//  Created by Michael Clark on 11/09/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCNibLoadingView.h"

@protocol MCAlertObjectProtocol;
@protocol MCAlertObjectUIProtocol;

@class MCPDocument, MCGradientColor;

@interface MCAlertAbstractActionView : MCNibLoadingView {
	IBOutlet NSObjectController     *alertController;
	
	
	id <MCAlertObjectProtocol,MCAlertObjectUIProtocol>    __alert;
	
	MCGradientColor*             __gradientColor;

	MCPDocument*                  __document; //  non retained
}

- (NSSize)additionalSizeRequired: (BOOL*)isNegativeDelta;


- (IBAction)dismissAlert: (id)sender;
- (IBAction)breakEntry: (id)sender;

- (id <MCAlertObjectProtocol,MCAlertObjectUIProtocol>)alert;
- (void)setAlert:(id <MCAlertObjectProtocol,MCAlertObjectUIProtocol>)anAlert;

- (MCGradientColor *)gradientColor;
- (void)setGradientColor:(MCGradientColor *)aGradientColor;

- (MCPDocument *)document;
- (void)setDocument:(MCPDocument *)aDocument;

@end
